

*******************************************************************************************
*                               Code for reproducing
*         "Switching a Face-to-Face Panel to Self-Administered Survey Modes: 
*    Experimental Evidence on Effects of Mode Assignment on Response and Selectivity"
*       By: Jette Schröder, Claudia Schmiedeberg, Josef Brüderl, Christiane Bozoyan
*                                  27. January 2025
*******************************************************************************************


**********************************************************************
*                         Do-File 02: 
* Analyzing the data (W14_gross_sample_plus_W13_W12 - analysis file.dta)
* that were generated with the Do-File: 01 Mode-Experiment pairfam W14_Data preparation.do
**********************************************************************
* Outcome:   "response" (1=interview completed, 0=no interview)
* Treatment: "self" (1=interviewer-administered, 0=self-administered)

version 18.0		 // Version of Stata used for the paper
set scheme s1mono    // graph scheme used in the paper

global path_generated_data C:\Daten\pairfam\temp    //directory of generated data sets

cd  "$path_generated_data"
use "W14_gross_sample_plus_W13_W12 - analysis file", clear   // load data


********************************************************************************
* Descriptive Statistics (TABLE A1)
********************************************************************************

* Missings
misstable summarize response self								///
    iscedgrouped emplstat   				                    /// moderators
    neurot extrav agreeable conscient openness               	/// Big Five
	female cohort sample 										// controls

* TABLE A1
dtable i.response i.self                       		 ///
    i.iscedgrouped  i.emplstat     					 /// moderators
    neurot extrav agreeable conscient openness	     /// Big Five
	i.female i.cohort i.sample,						 /// controls
	continuous(neurot extrav agreeable conscient openness, test(none)) /*nformat(%2.0f, )*/ export(descriptive_statistic.docx, replace)  

	 
	 
********************************************************************************
* Randomization check (TABLE A2)
********************************************************************************

reg self                                                      ///
    i.iscedgrouped  i.emplstat   			                  /// moderators
    neurot extrav agreeable conscient openness           /// big five (0-1 scale)
    i.female i.cohort i.sample                                 // controls
	
etable, mstat(N) mstat(r2, nformat(%4.3f)) showstars export("randomisation.docx", replace) showstarsnote


/*	The results as a Coefplot
coefplot, drop(_cons) xline(0, lc(red) lp(solid))                         ///
          m(O) mc(blue) ciopts(lc(blue))                              	  ///
		  xlabel(-.15(.05).15, format(%4.2f))                             ///
          xtitle("Effect on P(self-administered mode)", size(small))      ///
          ysize(15cm) xsize(14cm)  
*/



*******************************************************************************
* Treatment effect (TABLE A3) (FIGURE 1)
********************************************************************************

****** A cross-tabulation *******************************************
tab response self, col chi2       // treatment effect = -5.94 PP

reg response i.self               // perfectly reproduced by LPM

logit response i.self  
margins, dydx(self)               // and also by the AME after logit



*******  Treatment effect: Profile-Plot (FIGURE 1a) ***********
reg response i.self 
margins i.self
marginsplot, name(c,replace) horizontal title("")                                ///
              xscale(alt titlegap(3rs)) xtitle("P(response)",  size(med))        ///
              xlabel(0.68 (0.02) 0.80, format(%4.2f) grid gmax gmin 			 ///
			    glpattern(dash) glcolor(gs14) glwidth(0.5pt))                    ///
              yscale(range(-0.5 1.5))  ytitle ("")                               ///
              ylabel(0 "Face-to-face (N=1,200)"                                  ///
                     1 "Self-administered (N=6,226)" , labelminlen(26))          ///
              plotopts(lwidth(none) m(O) msize(medium) mc(blue*1.25) ) 			 ///
              ciopts(lwidth(medthick) lcolor(blue*1.25))                         ///
              graphregion(margin(small)) 
		  
						 
******* ATEs from four models ****************************************

****** M1: Linear probability model (LPM)
reg response i.self
est store M1

****** M2: LPM with controls
reg response i.self                                         ///
    i.iscedgrouped i.emplstat                  	            /// moderators
	neurot extrav agreeable conscient openness            	/// big five
	i.female i.cohort i.sample								 // controls
est store M2

****** M3: Logit with controls
logit response i.self                                       ///
    i.iscedgrouped i.emplstat   			   	            /// moderators
	neurot extrav agreeable conscient openness 		   	    /// big five
	i.female i.cohort i.sample								 // controls
margins, dydx(self i.iscedgrouped i.emplstat   	            ///
	neurot extrav agreeable conscient openness  		   	/// 
	female i.cohort i.sample) post
est store M3


****** M4: LPM with interviewer dummies

* Identifying those interviewers, who participated in the randomisation
codebook intid       // 286 interviewers, 7,426 interviews assigned
* tab intid self     // many of these had no F2F interviews assigned (were not part of the experiment)

bysort intid: egen int_exp=min(self)             // 0=in experiment , 1=not in experiment
replace int_exp=1  if intid==1558 | intid==1737  // 2 interviewers with only 1 F2F interview

codebook intid   if int_exp==0  // 128 interviewers, 5,476 interviews assigned

fre self         if int_exp==0  // 1,198 F2F interviews

reg response i.self i.intid, notable                // with all interviewers
margins, dydx(self)

reg response i.self i.intid if int_exp==0, notable  // only interviewers in experiment
est store M4
margins, dydx(self)                                 // ATE identical


*** Table with all models (TABLE A3)
etable, estimates (M1 M2 M3 M4) keep(i.self         ///
    i.iscedgrouped i.emplstat                       ///
	neurot extrav agreeable conscient openness      ///
	i.female i.cohort i.sample)						///
	mstat(N) mstat(r2, nformat(%4.3f)) showstars export("robustness_check.docx", replace) showstarsnote

	
*** Coefplot: ATEs for the four models (FIGURE 1b)

global opts  "ciopts(recast(rcap) lc(blue*1.25) lw(medthick)) msize(medium) mc(blue*1.25)"

coefplot (M1, aseq("M1: LPM w/o controls (N=7,426)")      $opts)  ///
         (M2, aseq("M2: LPM with controls (N=7,173)")     $opts)  ///
         (M3, aseq("M3: Logit with controls (N=7,173)")   $opts)  ///
		 (M4, aseq("M4: LPM fixed effects (N=5,476)")     $opts), ///
          name(d, replace)  keep(1.self) m(O) swapnames           ///
		  xscale(titlegap(3rs))									  ///
		  xlabel(-.10(.02).02, format(%4.2f) grid gmax gmin 	  ///
		     glpattern(dash) glcolor(gs14) glwidth(0.5pt))        ///
          xtitle("ATE of self-administered mode on P(response)")  ///
          ylabel( , labelminlen(26)) grid(glc(black) glwidth(0.15))             ///
          xline(0, lc(red) lp(solid))                             ///
          graphregion(margin(small))                               ///
		  legend(off) 
	  
graph combine c d , col(1) iscale(1) ysize(3.67) xsize(6) 

graph export  Figure_1.pdf, replace


		  
*********************************************************
* Moderation by education (ISCED) (TABLE A4)(FIGURE 2)
*********************************************************
							
/* Which education variable to use?
We do not use the variable yeduc (years of education), because only those in school are classified as enrolled, but not those in voational training (those in vocational training are coded based on their school certificate).
We use instead the variable isced, because here both those in school (school) and those in vocational training (vocat) are coded as enrolled. */

fre iscedgrouped

* LPM with education as moderator (plus three controls)
reg response i.self##(ib1.iscedgrouped     i.female i.cohort i.sample)

***** TABLE A4 ********************************************
etable, mstat(N) mstat(r2, nformat(%4.3f)) showstars export("isced.docx", replace) showstarsnote


**** For each education group: predicted probabilities and ATE (FIGURE 2) ******

tab iscedgrouped if e(sample)==1    // we need the N in the eduational groups

margins i.self, at(iscedgrouped=(1(1)4))  // predicted probabilities
mplotoffset, name(c, replace) offset(0.12) 										///
		plot1opts(connect(none) msymbol(D) msize(medsmall) mcolor("91 192 222")) ///
		plot2opts(connect(none) msymbol(O) msize(medium)   mcolor(blue*1.25))   ///
		ci1opts(lwidth(medthick) lcolor("91 192 222"))  			    		///
		ci2opts(lwidth(medthick) lcolor("blue*1.25"))                     		///
		title("")  fysize(120)  												///
		ytitle("P(response)", size(med)) yscale(range(0.55 0.8))                ///
		ylabel(0.4(0.05)0.9, format(%4.2f) angle(0) labelminlen(5)              ///
		       grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) 				///
		xtitle("Education") xscale (range(0.5 4.5)) fxsize(80)					/// 
		xlabel(1 `""≤ lower sec." "(N=373)""'                                   ///
			        2 `""upper sec." "(N=2,059)""' 3 `""post sec." "(N=718)""'  ///
					4 `""tertiary" "(N=2,506)""', angle(90)) 					///
		legend(pos(4) ring(0) row(2) region(lcolor(none)) symxsize(7) 			///
		       size(medsmall) order(2 1) lab(1 "face-to-face")                  ///
			   lab(2 "self-administered"))                

margins, dydx(self) at(iscedgrouped=(1 2 3 4))      // ATEs in the educational groups
marginsplot, name(d, replace) 													///
		plot1opts(lwidth(none) msymbol(O) msize(medium) mcolor("92 184 92"))    ///
		ci1opts(lwidth(medthick) lcolor("92 184 92"))                           ///
		title("")  fysize(50)                         							///
		xtitle("") xscale (range(0.5 4.5) )  xlabel(none)	fxsize(80) 	        ///
		ytitle("Δ P(response)", size(med))  ylabel( ,format(%4.2f) angle(0)     ///
		      labelminlen(5) grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) ///		
		yline(0, lcolor(gs5) lwidth(0.5pt) lpattern(dash)) 

graph combine d c, col(1) iscale(1) ysize(3.67) xsize(2.67) imargin (0) 

graph export  Figure_2.pdf, replace

* Testing the significance of the contrasts
reg response i.self##(ib1.iscedgrouped     i.female i.cohort i.sample), notable
margins, dydx(self) at(iscedgrouped=(1 2 3 4)) post     // ATEs in the educational groups

test _b[1.self:1._at] = _b[1.self:2._at] = _b[1.self:3._at] = _b[1.self:4._at], mtest
test                    _b[1.self:2._at] = _b[1.self:3._at] = _b[1.self:4._at], mtest
test                                       _b[1.self:3._at] = _b[1.self:4._at], mtest



*********************************************************
* Moderation by employment status (emplstat) (TABLE A5)(FIGURE 3)
*********************************************************

fre emplstat

* LPM with emplstat as moderator (plus three controls, plus education as control)
*	 "ib5" (education) to maximize contrasts
reg response i.self##(ib5.emplstat    i.female i.cohort i.sample i.iscedgrouped )

***** TABLE A5 ********************************************
etable, mstat(N) mstat(r2, nformat(%4.3f)) showstars export("emplstat.docx", replace) showstarsnote


**** For each employment status: predicted probabilities and ATE (FIGURE 3) ******

tab emplstat if e(sample)==1    // we need the N in the employment groups

margins i.self, at(emplstat=(0 1 2 3 4 5 6))  // predicted probabilities
mplotoffset, name(c, replace) offset(0.12) 										 ///
		plot1opts(connect(none) msymbol(D) msize(medsmall) mcolor("91 192 222")) ///
		plot2opts(connect(none) msymbol(O) msize(medium)   mcolor(blue*1.25))    ///
		ci1opts(lwidth(medthick) lcolor("91 192 222"))  			    		 ///
		ci2opts(lwidth(medthick) lcolor(blue*1.25))                     		 ///
		title("")  fysize(120)  												 ///
		ytitle("P(response)", size(med)) yscale(range(0.4 1.0))                  ///
		ylabel(0.4(0.05)1, format(%4.2f) angle(0) labelminlen(5)                 ///
		       grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) 			   	 ///
		xtitle("Employment status") xscale(range(0.5 6.5)) fxsize(110)			 /// 
        xlabel(0 `""homemaker" "(N=353)""'   1 `""part-time" "(N=1,437)""'     	 ///
	           2 `""full-time" "(N=3,054)""' 3 `""self-employed" "(N=338)""' 	 ///
			   4 `""unemployed" "(N=241)""'  5 `""in education" "(N=1,703)""' 	 ///
			   6 `""other" "(N=274)""', angle(90)) 								 ///
		legend(pos(4) ring(0) row(2) region(lcolor(none)) symxsize(7)            ///
		       size(medsmall) order(2 1)  lab(1 "face-to-face")                  ///
			   lab(2 "self-administered"))              

margins, dydx(self) at(emplstat=(0 1 2 3 4 5 6)) // ATEs in the employment groups
marginsplot, name(d, replace) 													///
		plot1opts(lwidth(none) msymbol(O) msize(medium) mcolor("92 184 92"))    ///
		ci1opts(lwidth(medthick) lcolor("92 184 92"))                           ///
		title("")  fysize(40)                         							///
		xtitle("") xscale (range(0.5 6.5) )  xlabel(none)	fxsize(110) 	    ///
		ytitle("Δ P(response)", size(med))  ylabel( ,format(%4.2f) angle(0)     ///
		      labelminlen(5) grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) ///		
		yline(0, lcolor(gs5) lwidth(0.5pt) lpattern(dash)) 

graph combine d c, col(1) iscale(1) ysize(3.67) xsize(2.67) imargin (0)

graph export  Figure_3.pdf, replace


* Testing the significance of the contrasts
reg response i.self##(ib5.emplstat    i.female i.cohort i.sample i.iscedgrouped ), notable
margins, dydx(self) at(emplstat=(0 1 2 3 4 5 6)) post     // ATEs in the employment groups

test _b[1.self:1._at] = _b[1.self:2._at] = _b[1.self:3._at] = _b[1.self:4._at] = _b[1.self:5._at] = _b[1.self:6._at] = _b[1.self:7._at], mtest
test                    _b[1.self:2._at] = _b[1.self:3._at] = _b[1.self:4._at] = _b[1.self:5._at] = _b[1.self:6._at] = _b[1.self:7._at], mtest
test                                       _b[1.self:3._at] = _b[1.self:4._at] = _b[1.self:5._at] = _b[1.self:6._at] = _b[1.self:7._at], mtest
test                                                          _b[1.self:4._at] = _b[1.self:5._at] = _b[1.self:6._at] = _b[1.self:7._at], mtest
test                                                                             _b[1.self:5._at] = _b[1.self:6._at] = _b[1.self:7._at], mtest
test                                                                                                _b[1.self:6._at] = _b[1.self:7._at], mtest



*********************************************************
* Moderation by Big Five (TABLE A6)(FIGURE 4)
*********************************************************

* Each scale is 1 to 5
fre conscient

* LPM with all Big Fives as moderators in one model (plus three controls)
*	 We estimate linear moderation effects!
reg response i.self##(c.neurot c.agreeable c.conscient c.openness c.extrav  i.female i.cohort i.sample) 


**** TABLE A6 **********************************************
etable, mstat(N) mstat(r2, nformat(%4.3f)) showstars export("bigfive.docx", replace) showstarsnote


**** For each Big Five scale: predicted probabilities and ATE (FIGURE 4) ******


* First only Neuroticism (with y-axis)
foreach var of varlist neurot {
if `var'== neurot    local a= "Neuroticism"

* Predicted probabilities
margins i.self, at(`var'=(1 2 3 4 5))
mplotoffset, name(c`var', replace) offset(0.0) 								     ///
		plot1opts(msymbol(D) msize(medsmall) mcolor("91 192 222") lpattern(l) lcolor("91 192 222"))    ///
		plot2opts(msymbol(O) msize(medium)   mcolor(blue*1.25)    lpattern(l) lcolor(blue*1.25) )      ///
		ci1opts(lwidth(medthick) lcolor("91 192 222"))  			    		 ///
		ci2opts(lwidth(medthick) lcolor(blue*1.25))                     		 ///
		title("")  fysize(100)  												 ///
		ytitle("P(response)", size(med)) yscale(range(0.55 1))                   ///
		yscale(range (0.55 1.02)) ylabel(0.55(0.05)1, format(%4.2f) angle(0)     ///
		       labelminlen(4) grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) ///				              
		xtitle("") xscale(range(1 5)) fxsize(145)			                     /// 
        xlabel(1 `""1" "    (low)""' 2 `"2"' 3 `"3"' 4 `"4"' 5 `""5" "(high)    ""',    ///
			   angle(0))  													     ///
		legend(pos(4) ring(0) row(2)  size(medsmall) region(lcolor(none))        ///
		       symxsize(7) order(2 1) lab(1 "face-to-face")                      ///
			   lab(2 "self-administered")) 

* ATE moderated by scale value
margins, dydx(self) at(`var'=(1 2 3 4 5 ))
marginsplot, name(d`var', replace) 													  ///
		plot1opts(msymbol(O) msize(medium) mcolor("92 184 92") lcolor("92 184 92"))   ///
		ci1opts(lwidth(medthick) lcolor("92 184 92"))                       	      ///
		title("                `a'")  fysize(60)                         			  ///
		xtitle("") xscale(range(1 5) )  xlabel(none)	fxsize(145) 	    	      ///
		ytitle("Δ P(response)", size(med)) yscale(range (-0.4 0.2))                   ///
		ylabel(-0.4(0.1)0.2,format(%4.2f) angle(0) labelminlen(4) grid                ///
		       glpattern(dash) glcolor(gs14) glwidth(0.5pt)) 						  ///		
		yline(0, lcolor(gs5) lwidth(0.5pt) lpattern(dash)) 
}


* Then the rest (without y-axis)
foreach var of varlist agreeable conscient openness extrav {
if `var'== agreeable local a= "Agreeableness"
if `var'== conscient local a= "Conscientiousness"
if `var'== openness  local a= "Openness"
if `var'== extrav    local a= "Extraversion"

* Predicted probabilities
margins i.self, at(`var'=(1 2 3 4 5))
mplotoffset, name(c`var', replace) offset(0.0) 										///
		plot1opts(msymbol(D) msize(medsmall) mcolor("91 192 222") lpattern(l) lcolor("91 192 222"))   ///
		plot2opts(msymbol(O) msize(medium)   mcolor(blue*1.25)    lpattern(l) lcolor(blue*1.25) )     ///            
		ci1opts(lwidth(medthick)  lcolor("91 192 222"))  			    		    ///
		ci2opts(lwidth(medthick)  lcolor(blue*1.25))                     		    ///
		title("")  fysize(100)  												    ///
		ytitle("") yscale(range(0.55 1))                  							///
		yscale(range (0.55 1.02)) ylabel(0.55(0.05)1, nolabels noticks 				///
		       grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) 				    ///
		xtitle("") xscale(range(1 5)) fxsize(110)			                    	/// 
        xlabel(1 `""1" "    (low)""' 2 `"2"' 3 `"3"' 4 `"4"' 5 `""5" "(high)    ""', ///
			   angle(0))  legend (off)

* ATE moderated by scale value
margins, dydx(self) at(`var'=(1 2 3 4 5 ))
marginsplot, name(d`var', replace) 													///
		plot1opts(msymbol(O) msize(medium) mcolor("92 184 92") lcolor("92 184 92")) ///
		ci1opts(lwidth(medthick) lcolor("92 184 92"))                       		///
		title("`a'")  fysize(60)                         							///
		xtitle("") xscale(range(1 5) )  xlabel(none)	fxsize(110) 	    		///
		ytitle("") yscale(range (-0.4 0.2)) ylabel(-0.4(0.1)0.2, nolabels noticks 	///
						grid glpattern(dash) glcolor(gs14) glwidth(0.5pt)) 			///		
		yline(0, lcolor(gs5) lwidth(0.5pt) lpattern(dash)) 
}


* Combining the five
graph combine dneurot dextrav dagreeable dconscient dopenness  ///
              cneurot cextrav cagreeable cconscient copenness, ///
			  col(5) ysize(4.5) xsize(6.0) imargin(0 0 0 0 0 0 0 0 0 0)
			 
graph export  Figure_4.pdf, replace


